@extends('layouts.front', ['title' => __('Orders')])

@section('content')
    @include('users.partials.header', ['title' => ''])


    <div class="container-fluid mt--7">

        <div class="col-xl-8 offset-xl-2">
            <div class="card bg-secondary shadow">
                <div class="card-header bg-white border-0">
                    <div class="row align-items-end flex-nowrap">

                        <div class="col-sm-8 align-items-start">
                            <a href="{{ $backUrl }}" type="button" class="btn btn-primary btn-lg left text-white">
                                <span class="btn-inner--icon"><i class="fa fa-chevron-left"></i></span>
                                <span class="btn-inner--text">{{ __('Go Back') }}</span>
                            </a>
                        </div>
                        <div class="col-sm-4" style=" display: flex; justify-content: flex-end">
                            <a href="{{ url()->current() }}" type="button"
                                class="btn btn-primary btn-lg align-items-right text-white">
                                <span class="btn-inner--icon"><i class="fa fa-refresh"></i></span>
                                <span class="btn-inner--text">{{ __('Refresh') }}</span>
                            </a>
                        </div>



                    </div>
                </div>
            </div>
        </div>
        <br />
        @foreach ($orders as $order)
            <div class="col-xl-8 offset-xl-2">
                <div class="card bg-secondary shadow">
                    <div class="card-header bg-white border-0">
                        <div class="row align-items-center">
                            <h3 class="col-12 mb-0">{{ __('Order') . ' #' . $order->id_formated }}</h3>
                        </div>
                    </div>
                    @include('orders.partials.orderstatus')
                    @include('orders.partials.orderinfo')

                    <!-- WHATS APP Buttton -->
                    @if ($showWhatsApp)
                        <a target="_blank" href="{{ route('order.success') }}?order={{ $order->id }}&whatsapp=yes"
                            class="btn btn-lg btn-icon btn btn-success mt-4 paymentbutton">
                            <span style="color:white" class="btn-inner--icon lg"><i class="fa fa-whatsapp"
                                    aria-hidden="true"></i></span>
                            <span style="color:white" class="btn-inner--text">{{ __('Send order on WhatsApp') }}</span>
                        </a>
                    @endif

                </div>
            </div>
            <br />
        @endforeach




    </div>
@endsection
@section('js')

  <script async defer src= "https://maps.googleapis.com/maps/api/js?key=<?php echo config('settings.google_maps_api_key'); ?>&callback=initAddressMap"></script>
  <!-- Stripe -->
  <script src="https://js.stripe.com/v3/"></script>
  <script>
    "use strict";
    var RESTORANT = <?php echo json_encode($restorant) ?>;
    var STRIPE_KEY="{{ config('settings.stripe_key') }}";
    var ENABLE_STRIPE= true;
    var SYSTEM_IS_QR="{{ config('app.isqrexact') }}";
    var SYSTEM_IS_WP="{{ config('app.iswp') }}";
    var initialOrderType = 'delivery';
    if(RESTORANT.can_deliver == 1 && RESTORANT.can_pickup == 0){
        initialOrderType = 'delivery';
    }else if(RESTORANT.can_deliver == 0 && RESTORANT.can_pickup == 1){
        initialOrderType = 'pickup';
    }
  
     var stripe = Stripe(STRIPE_KEY);

    // Create an instance of Elements.
    var elements = stripe.elements();

    // Custom styling can be passed to options when creating an Element.
    // (Note that this demo uses a wider set of styles than the guide below.)
    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    var options = {
        // Custom styling can be passed to options when creating an Element.
        style: {
            base: {
                // Add your base input styles here. For example:
                fontSize: '16px',
                color: '#32325d',
                padding: '2px 2px 4px 2px',
            },
        }
    }

    // Create an instance of the card Element.
    var card = elements.create('card', { style: style });

    // Add an instance of the card Element into the `card-element` <div>.
    card.mount('#card-element');

    // Handle real-time validation errors from the card Element.
    card.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    const cardHolderName = document.getElementById('name');

    // Handle form submission  - for card.
    var form = document.getElementById('stripe-payment-form');
    form.addEventListener('submit', async function(event) {
        event.preventDefault();

        //IF delivery - we need to have selected address
       
            const { paymentMethod, error } = await stripe.createPaymentMethod(
                'card', card, {
                    billing_details: { name: cardHolderName.value }
                }
            );

            if (error) {
                // Display "error.message" to the user...
                alert(error.message);
            } else {
                stripePaymentMethodHandler(paymentMethod.id);
            }
        



    });

    // Submit the form with the payment ID.
    function stripePaymentMethodHandler(payment_id) {
        // Insert the token ID into the form so it gets submitted to the server
        var form = document.getElementById('order-form');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'stripePaymentId');
        hiddenInput.setAttribute('value', payment_id);
        form.appendChild(hiddenInput);

        // Submit the form
        form.submit();

        //Disable the field
        $('#stripeSend').hide();
        $('#indicatorStripe').show();
        setTimeout(function() {
            $('#stripeSend').show();
            $('#indicatorStripe').hide();
        }, 10000);
    }
    </script>
  @endsection
