<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Wilio Survey, Quotation, Review and Register form Wizard by Ansonika.">
    <meta name="author" content="Ansonika">
    <title>lapaas store</title>

    <!-- Favicons-->
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114"
        href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144"
        href="img/apple-touch-icon-144x144-precomposed.png">

    <!-- GOOGLE WEB FONT -->
    <link href="https://fonts.googleapis.com/css?family=Work+Sans:400,500,600" rel="stylesheet">

    <!-- BASE CSS -->
    <link href="{{ asset('customer/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('customer/css/menu.css') }}" rel="stylesheet">
    <link href="{{ asset('customer/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('customer/css/vendors.css') }}" rel="stylesheet">

    <!-- YOUR CUSTOM CSS -->
    <link href="{{ asset('customer/css/custom.css') }}" rel="stylesheet">
    <link href="{{ asset('customer/index.css') }}" rel="stylesheet">



    <!-- MODERNIZR MENU -->

    <script src="{{ asset('customer/js/modernizr.js') }}"></script>


</head>

<body>

    <div id="preloader">
        <div data-loader="circle-side"></div>
    </div><!-- /Preload -->

    <div id="loader_form">
        <div data-loader="circle-side-2"></div>
    </div><!-- /loader_form -->


    <!-- /menu -->

    <div class="container-fluid full-height">
        <div class="row row-height">

            <!-- /content-left -->

            <div class="col-lg-12 content-right" id="start">
                <div id="wizard_container" >
                    <div id="top-wizard">
                        <div id="progressbar"></div>
                    </div>
                    <input type="hidden" name="base_url" value="{{config('app.url') }}" id="site_url">
                    <!-- /top-wizard -->
                    <form id="dic" enctype="multipart/form-data" method="POST"
                        action="{{ route('new-customer-register') }}">
                        @csrf
                        <input id="website" name="website" type="text" value="">
                       
                        <!-- Leave for security protection, read docs for details -->
                        <div id="middle-wizard">
                            <div class="step">
                                <h3 class="main_question"><strong>1/2</strong>Please Select table</h3>
                                 @if (Session::has('success'))
                           <label> {{ Session::get('success') }}</label>
                        @elseif(Session::has('errors'))
                          <label>  {{ Session::get('errors')->first() }} </label><!-- here to 'withWarning()' -->
                        @endif
                                <div class="form-group">
                                    <input type="hidden" name="new_order" id="new_order" value="1" />
                                    <input type="hidden" name="restaurant_id" id="restaurant_id" value="{{ $restorant->id }}" />
                                    @if ($table_id > 0)
                                        <input type="hidden" name="table_id" id="table_id"
                                            value="{{ $table_id }}" />
                                    @endif
                                    <input type="hidden" name="order_id" id="order_id" value="1" />
                                    <label>Select Table</label>
                                    <select name="table_id" id="table_id" {{ $table_id > 0 ? 'disabled' : '' }}
                                        class="select-box form-control teammate_select">
                                        <option value="">Select Table</option>
                                        @if (count($tables) > 0)
                                            @foreach ($tables as $table)
                                                <option data-size="{{ $table->size }}"
                                                    {{ $table_id == $table->id ? 'selected' : '' }}
                                                    value="{{ $table->id }}">
                                                    {{ $table->name . ' (' . $table->size . ')' }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>



                            </div>
                            <!-- /step-->
                            <div class="submit step">
                                <h3 class="main_question"><strong>2/2</strong>Fill your details</h3>
                                <div class="exist_order" style="display: none">
                                    <div class="form-group">
                                        <select name="customer_id" id="customer_id"
                                            class="select-box  form-control select_customer">
                                            <option value="">Select Name</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="new_order">
                                    <div class="form-group">

                                        <input type="text" class="form-control" name="name"
                                            placeholder="Enter full name" />
                                        <input type="hidden" name="alias" value="{{ $alias }}">
                                    </div>
                                    <div class="form-group">

                                        <input type="email" class="form-control" name="email"
                                            placeholder="Enter email address" />
                                    </div>
                                    <div class="form-group">

                                        <input type="text" class="form-control" name="mobile"
                                            onkeyup="validateNumber(this)" placeholder="Enter phone number" />
                                    </div>

                                    <div class="teammate-container form-group">
                                        <label>Have a teammate (If Yes Please Mention Name) </label>
                                        <button type="button" class="button01" id="addTeammate">+</button>
                                    </div>
                                </div>












                            </div>




                            <!-- /step-->




                            <!-- /step-->
                        </div>
                        <!-- /middle-wizard -->
                        <div id="bottom-wizard">



                            <button type="button" name="backward" class="backward">Prev</button>
                            <button type="button" name="forward" class="forward">Next</button>
                            <button type="submit" id="submit_form" name="process"
                                class="submit submit_form">Submit</button>
                        </div>
                        <!-- /bottom-wizard -->
                    </form>
                </div>
                <!-- /Wizard container -->
            </div>
            <!-- /content-right-->
        </div>
        <!-- /row-->
    </div>
    <!-- /container-fluid -->

    <div class="cd-overlay-nav">
        <span></span>
    </div>
    <!-- /cd-overlay-nav -->

    <div class="cd-overlay-content">
        <span></span>
    </div>
    <!-- /cd-overlay-content -->




    <!-- COMMON SCRIPTS -->
    <script src="{{ asset('customer/js/jquery-3.6.3.min.js') }}"></script>
    <script src="{{ asset('customer/js/common_scripts.min.js') }}"></script>
    <script src="{{ asset('customer/js/velocity.min.js') }}"></script>
    <script src="{{ asset('customer/js/functions.js') }}"></script>
    <!-- Wizard script -->
    <script src="{{ asset('customer/js/survey_func.js') }}"></script>
    <script src="{{ asset('customer/index.js') }}"></script>
    <script src="{{ asset('vendor') }}/axios/axios.min.js"></script>
    <script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.12.0/jquery.validate.min.js"></script>
    <script>
        function validateNumber(input) {
            var pattern = /^[0-9]*$/;
            if (!pattern.test(input.value)) {
                input.value = "";
                // alert("Please enter a valid number.");
            }
        }

        function findorder(table_id) {
            axios.get($('#site_url').val() + '/findorder/' + table_id).then(function(response) {
                    if (response.data.newOrders) {
                        $('.new_order').show();
                        $('.exist_order').hide();
                        $('#new_order').val(1);
                    } else {
                        $('#new_order').val(0);
                        $('#order_id').val(response.data.order_id);
                        $.each(response.data.teammates, function(index, val) {
                            $('#customer_id').append('<option value="' + response.data.customer_id + '">' +
                                val + '</option>');
                        });
                        $('#customer_id').append('<option value="' + response.data.customer_id + '">' + response.data
                            .customer_name + '</option>');


                        $('.new_order').hide();
                        $('.exist_order').show();

                    }
                })
                .catch(function(error) {
                    // console.log(error);
                    $('.new_order').show();
                    $('#new_order').val(1);
                    $('.exist_order').hide();


                });
        }
    </script>
    @if ($table_id > 0)
        <script>
            var table_id = $('#table_id').val();
            findorder(table_id);
        </script>
    @else
        <script>
            // $('.custom_select').select2();

            $(document).on("change", "#table_id", function() {
                var table_id = $(this).val();

                findorder(table_id);

            });











            // var v = $('#wrapped').validate({
            //     errorClass: "my-error-class",
            //     validClass: "my-valid-class",
            //     rules: {
            //         "name": {
            //             required: true,
            //         },
            //         "email": {
            //             required: true,
            //             email: true,
            //         },
            //         password: {
            //             minlength: 8,
            //         },
            //         password_confirmation: {
            //             minlength: 8,
            //             equalTo: "#password"
            //         },
            //         th: {
            //             required: true,
            //         }
            //     },

            // });

            // $('#name').blur(function() {
            //     v.element('#name');
            // });
        </script>
    @endif
</body>

</html>
